/*
 * clTogglingSequences.cpp
 *
 *  Created on: Nov 19, 2012
 *      Author: vo84hi
 */

//#include "precompiled.hh"

#include "AudioStack/clTogglingSequences.h"

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clTogglingSequences.cpp.trc.h"
#endif

namespace AudioStack
{


std::map<AudioSources::enAudioSources,AudioSources::enAudioSources> clTogglingSequences::ToggleSeq_RmtCtrl;
std::map<AudioSources::enAudioSources,AudioSources::enAudioSources> clTogglingSequences::ToggleSeq_Aux;
std::map<AudioSources::enAudioSources,AudioSources::enAudioSources> clTogglingSequences::ToggleSeq_Radio;
std::map<AudioSources::enAudioSources,AudioSources::enAudioSources> clTogglingSequences::ToggleSeq_CD;


AudioSources::enAudioSources clTogglingSequences::GetNextSourceClass(AudioSources::enAudioSources source,
                                                                AudioToggleGroups::enToggleGroup toggleGroup)
{
   vInitToggleSeq();

   AudioSources::enAudioSources nextSrc = AudioSources::NONE;

   switch(toggleGroup)
   {
      case AudioToggleGroups::AUX:
      {
         if(FindToggleGroup(source) == AudioToggleGroups::AUX)
         {
            nextSrc = ToggleSeq_Aux[source];
         }
      }
      break;
      case AudioToggleGroups::CD:
      {
         if(FindToggleGroup(source) == AudioToggleGroups::CD)
         {
            nextSrc = ToggleSeq_CD[source];
         }
      }
      break;
      case AudioToggleGroups::SD:
      {
         if(FindToggleGroup(source) == AudioToggleGroups::SD)
         {
            nextSrc = AudioSources::MEDIA_SD_1;
         }
      }
      break;
      case AudioToggleGroups::RADIO:
      default:
      {
         if(FindToggleGroup(source) == AudioToggleGroups::RADIO)
         {
            nextSrc = ToggleSeq_Radio[source];
         }
      }
      break;
      case AudioToggleGroups::MFL_ORDER:
      {
         if(FindToggleGroup(source) == AudioToggleGroups::MFL_ORDER)
         {
            nextSrc = ToggleSeq_RmtCtrl[source];
         }
      }
      break;
   }
   ETG_TRACE_USR4(("GetNextSource: Actual: %d, Group: %d, Next: %d",
         ETG_CENUM(AudioSources::enAudioSources, source),
         ETG_CENUM(AudioToggleGroups::enToggleGroup, toggleGroup),
         ETG_CENUM(AudioSources::enAudioSources, nextSrc)));
   return nextSrc;
}

AudioToggleGroups::enToggleGroup clTogglingSequences::FindToggleGroup(AudioSources::enAudioSources source)
{
   AudioToggleGroups::enToggleGroup group = AudioToggleGroups::NONE;

   vInitToggleSeq();

   if(ToggleSeq_Aux.find(source) != ToggleSeq_Aux.end())
      group = AudioToggleGroups::AUX;
   if(ToggleSeq_Radio.find(source) != ToggleSeq_Radio.end())
         group = AudioToggleGroups::RADIO;
   if(ToggleSeq_CD.find(source) != ToggleSeq_CD.end())
      group = AudioToggleGroups::CD;

   ETG_TRACE_USR1(("FindToggleGroup for source: %d is %d",
         ETG_CENUM(AudioSources::enAudioSources, source),
         ETG_CENUM(AudioToggleGroups::enToggleGroup, group)));
   return group;
}

/**
 *  INLINE METHOD
 */
tVoid clTogglingSequences::vInitToggleSeq()
{
   if(ToggleSeq_Aux.size()== 0)
   {
      vInitToggleSeq_Aux();
   }

   if(ToggleSeq_CD.size()== 0)
   {
      vInitToggleSeq_CD();
   }

   if(ToggleSeq_Radio.size()== 0)
   {
      vInitToggleSeq_Radio();
   }

   if(ToggleSeq_RmtCtrl.size()== 0)
   {
      vInitToggleSeq_RmtCtrl();
   }
}

tVoid clTogglingSequences::vInitToggleSeq_CD()
{
   ToggleSeq_CD[AudioSources::MEDIA_CDDA]   = AudioSources::MEDIA_CDDA;
}

tVoid clTogglingSequences::vInitToggleSeq_Radio()
{
   ToggleSeq_Radio[AudioSources::TUNER_FM]   = AudioSources::TUNER_AM;
   ToggleSeq_Radio[AudioSources::TUNER_AM]   = AudioSources::TUNER_DAB;
   ToggleSeq_Radio[AudioSources::TUNER_DAB]   = AudioSources::TUNER_FM;
}


/**
 * Toggling Sequence for Aux Group Sources
 * @return
 */
tVoid clTogglingSequences::vInitToggleSeq_Aux()
{
   ToggleSeq_Aux[AudioSources::MEDIA_IPOD_1]             = AudioSources::MEDIA_USB_1;
   ToggleSeq_Aux[AudioSources::MEDIA_USB_1]              = AudioSources::MEDIA_DB_PLAYER;
   ToggleSeq_Aux[AudioSources::MEDIA_DB_PLAYER]          = AudioSources::SPI_ENTERTAIN;
   ToggleSeq_Aux[AudioSources::SPI_ENTERTAIN]            = AudioSources::MEDIA_BTAUDIO_1;
   ToggleSeq_Aux[AudioSources::MEDIA_BTAUDIO_1]          = AudioSources::AUX;
   ToggleSeq_Aux[AudioSources::AUX]         = AudioSources::MEDIA_IPOD_1;
}

/**
 * Toggle Sequence for Steering Wheel Control.
 * Requirement
 * https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-439045
 * @return
 */
tVoid clTogglingSequences::vInitToggleSeq_RmtCtrl()
{
  // switch via DP/KDS configuration NAM Variant
  // DPSYSTEM__VARIANT_CONFIG_SYSTEM_NISSAN_REG_TYPE
  // clHSA_Config.h => T_e8_NissanCountryType

//   cldp_Mngr*  poDataPool   = cldp_Mngr::pclGetInstance();
//   if(poDataPool == NULL)
//   {
//      ETG_TRACE_ERR(("vInitToggleSeq_RmtCtrl Pointer to Datapool is NULL"));
//      NORMAL_M_ASSERT_ALWAYS();
//   }
//  T_e8_NissanCountryType enCountryType = EUR;
//  tU8 magicVarType = 0;

  //Get Config from DP
//  if (poDataPool)
//     poDataPool->u32dp_get(DPSYSTEM__VARIANT_CONFIG_SYSTEM_NISSAN_REG_TYPE, &(magicVarType), sizeof(tU8));
//  //Because we are working on plain Byte and now we cast to some type based variables
//  enCountryType = static_cast<T_e8_NissanCountryType>(magicVarType);

//  ETG_TRACE_USR3((" RmtCtrl ToggleSequence Configuration:  %d ", \
//                    ETG_CENUM(T_e8_NissanCountryType, enCountryType)));

//  switch(enCountryType)
//  {
//     default:
      ETG_TRACE_USR3((" Init RmtCtrl ToggleSequence: Not-NAM Sequence"));
      ToggleSeq_RmtCtrl[AudioSources::TUNER_AM]                 = AudioSources::TUNER_DAB;
      ToggleSeq_RmtCtrl[AudioSources::TUNER_FM]                 = AudioSources::TUNER_DAB;
      ToggleSeq_RmtCtrl[AudioSources::TUNER_FM]                 = AudioSources::TUNER_DAB;
      ToggleSeq_RmtCtrl[AudioSources::TUNER_DAB]                = AudioSources::MEDIA_CDDA;
      ToggleSeq_RmtCtrl[AudioSources::MEDIA_CDDA]               = AudioSources::MEDIA_IPOD_1;
      ToggleSeq_RmtCtrl[AudioSources::MEDIA_IPOD_1]             = AudioSources::MEDIA_USB_1;
      ToggleSeq_RmtCtrl[AudioSources::MEDIA_USB_1]              = AudioSources::MEDIA_DB_PLAYER;
      ToggleSeq_RmtCtrl[AudioSources::MEDIA_DB_PLAYER]          = AudioSources::SPI_ENTERTAIN;
      ToggleSeq_RmtCtrl[AudioSources::SPI_ENTERTAIN]            = AudioSources::MEDIA_BTAUDIO_1;
      ToggleSeq_RmtCtrl[AudioSources::MEDIA_BTAUDIO_1]          = AudioSources::AUX;
      ToggleSeq_RmtCtrl[AudioSources::AUX]                      = AudioSources::TUNER_FM;
//      break;
//   case USA:
//   case CAN:
//   case MEX:
//      ETG_TRACE_USR3((" Init RmtCtrl ToggleSequence: NAM Sequence"));
//      ToggleSeq_RmtCtrl[AudioSources::RADIO_AM]               = AudioSources::RADIO_FM1_PRESETBANK_1;
//      ToggleSeq_RmtCtrl[AudioSources::RADIO_FM1_PRESETBANK_1] = AudioSources::RADIO_FM1_PRESETBANK_2;
//      ToggleSeq_RmtCtrl[AudioSources::RADIO_FM1_PRESETBANK_2] = AudioSources::RADIO_XM_PRESETBANK_1;
//      ToggleSeq_RmtCtrl[AudioSources::RADIO_XM_PRESETBANK_1]  = AudioSources::RADIO_XM_PRESETBANK_2;
//      ToggleSeq_RmtCtrl[AudioSources::RADIO_XM_PRESETBANK_2]  = AudioSources::RADIO_XM_PRESETBANK_3;
//      ToggleSeq_RmtCtrl[AudioSources::RADIO_XM_PRESETBANK_3]  = AudioSources::MEDIA_CDDA;
//      ToggleSeq_RmtCtrl[AudioSources::MEDIA_CDDA]             = AudioSources::MEDIA_CDCOMP;
//      ToggleSeq_RmtCtrl[AudioSources::MEDIA_CDCOMP]           = AudioSources::MEDIA_IPOD;
//      ToggleSeq_RmtCtrl[AudioSources::MEDIA_IPOD]             = AudioSources::MEDIA_USB;
//      ToggleSeq_RmtCtrl[AudioSources::MEDIA_USB]              = AudioSources::MEDIA_DB_PLAYER;
//      ToggleSeq_RmtCtrl[AudioSources::MEDIA_DB_PLAYER]        = AudioSources::SPI_USB;
//      ToggleSeq_RmtCtrl[AudioSources::SPI_USB]                = AudioSources::SPI_BT_AUDIO;
//      ToggleSeq_RmtCtrl[AudioSources::SPI_BT_AUDIO]           = AudioSources::MEDIA_BTAUDIO;
//      ToggleSeq_RmtCtrl[AudioSources::MEDIA_BTAUDIO]          = AudioSources::MEDIA_AUXPLATE;
//      ToggleSeq_RmtCtrl[AudioSources::MEDIA_AUXPLATE]         = AudioSources::RADIO_AM;
//      break;
  }

clTogglingSequences::clTogglingSequences()
{
   // TODO Auto-generated constructor stub

}

clTogglingSequences::~clTogglingSequences()
{
   // TODO Auto-generated destructor stub
}

}//namespace


